packer {
  required_version = ">=1.7.0"
  required_plugins {
    docker = {
      source  = "github.com/hashicorp/docker"
      version = ">=0.0.7"
    }
    chef = {
      source  = "github.com/hashicorp/chef"
      version = ">=1.0.0"
    }
  }
}

variable "cookbook_paths" {
  type    = string
  default = "cookbooks"
}

source "docker" "autogenerated_1" {
  discard = true
  image  = "ubuntu:latest"
}

build {
  description = "Create NGINX Docker image"

  sources = ["source.docker.autogenerated_1"]

  provisioner "shell" {
    inline = [
    "apt-get update",
    "apt-get -qq -y install curl sudo"
    ]
  }

  provisioner "chef-solo" {
    cookbook_paths = [var.cookbook_paths]
    run_list       = ["nginx"]
    skip_install   = false
  }
}
